#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

int res = 0;

#ifdef REFERENCE

/* make sure we use 32bit vars */
#define TESTA(_n,_a,_b,_r) \
    int32_t a = ((int32_t)_a), b = ((int32_t)_b); \
    if (((a/((int32_t)_b)) == ((int32_t)_r)) && ((a/b) == ((int32_t)_r))) { \
        return 0; \
    } else { \
        printf("%d incorrect: %d %d expected: %d/%d=%d\n", \
               (_n), (a/((int32_t)_b)), (a/b), ((int32_t)_a), ((int32_t)_b), ((int32_t)_r)); \
        return 1; \
    }
    
#define TESTB(_n,_a,_b,_r) \
    int32_t a = ((int32_t)_a), b = ((int32_t)_b); \
    if (((a/((int32_t)_b)) == (a/b))) { \
        return 0; \
    } else { \
        printf("%d Not Equal: %d %d expected: %d/%d=%d\n", \
               (_n), (a/((int32_t)_b)), (a/b), ((int32_t)_a), ((int32_t)_b), ((int32_t)_r)); \
        return 1; \
    }

#else

/* make sure we use 32bit vars */
#define TESTA(_n,_a,_b,_r) \
    int32_t a = ((int32_t)_a), b = ((int32_t)_b); \
    if (((a/((int32_t)_b)) == ((int32_t)_r)) && ((a/b) == ((int32_t)_r))) { \
        return 0; \
    } else { \
        printf("%d incorrect: %ld %ld expected: %ld/%ld=%ld\n", \
               (_n), (a/((int32_t)_b)), (a/b), ((int32_t)_a), ((int32_t)_b), ((int32_t)_r)); \
        return 1; \
    }
    
#define TESTB(_n,_a,_b,_r) \
    int32_t a = ((int32_t)_a), b = ((int32_t)_b); \
    if (((a/((int32_t)_b)) == (a/b))) { \
        return 0; \
    } else { \
        printf("%d Not Equal: %ld %ld expected: %ld/%ld=%ld\n", \
               (_n), (a/((int32_t)_b)), (a/b), ((int32_t)_a), ((int32_t)_b), ((int32_t)_r)); \
        return 1; \
    }

#endif
    
/* check if the result is correct */
int test1a(void) { TESTA(1, 1,  8,  0); }
int test2a(void) { TESTA(2,-1,  8,  0); }
int test3a(void) { TESTA(3, 1, -8,  0); }
int test4a(void) { TESTA(4, 8,  1,  8); }
int test5a(void) { TESTA(5,-8,  1, -8); }
int test6a(void) { TESTA(6, 8, -1, -8); }

int test7a(void)  { TESTA(7, 2048,  512,  4); }
int test8a(void)  { TESTA(8,-2048,  512, -4); }
int test9a(void)  { TESTA(9, 2048, -512, -4); }
int test10a(void) { TESTA(10,  512, 2048,  0); }
int test11a(void) { TESTA(11, -512, 2048,  0); }
int test12a(void) { TESTA(12,  512,-2048,  0); }

/* values that are around min/max of the type(s) */
int test13a(void) { TESTA(13, 127, 128,  0); }
int test14a(void) { TESTA(14,-127, 128,  0); }
int test15a(void) { TESTA(15, 127,-128,  0); }
int test16a(void) { TESTA(16, 128, 127,  1); }
int test17a(void) { TESTA(17,-128, 127, -1); }
int test18a(void) { TESTA(18, 128,-127, -1); }

int test19a(void) { TESTA(19, 32767, 32768,  0); }
int test20a(void) { TESTA(20,-32767, 32768,  0); }
int test21a(void) { TESTA(21, 32767,-32768,  0); }
int test22a(void) { TESTA(22, 32768, 32767,  1); }
int test23a(void) { TESTA(23,-32768, 32767, -1); }
int test24a(void) { TESTA(24, 32768,-32767, -1); }

int test25a(void) { TESTA(25, 2147483647, 2147483648,  0); }
int test26a(void) { TESTA(26,-2147483647, 2147483648,  0); }
int test27a(void) { TESTA(27, 2147483647,-2147483648,  0); }
int test28a(void) { TESTA(28, 2147483648, 2147483647,  1); }
int test29a(void) { TESTA(29,-2147483648, 2147483647, -1); }
int test30a(void) { TESTA(30, 2147483648,-2147483647, -1); }

/* check if the results are equal */
int test1b(void) { TESTB(1, 1,  8,  0); }
int test2b(void) { TESTB(2,-1,  8,  0); }
int test3b(void) { TESTB(3, 1, -8,  0); }
int test4b(void) { TESTB(4, 8,  1,  8); }
int test5b(void) { TESTB(5,-8,  1, -8); }
int test6b(void) { TESTB(6, 8, -1, -8); }

int test7b(void)  { TESTB(7, 2048,  512,  4); }
int test8b(void)  { TESTB(8,-2048,  512, -4); }
int test9b(void)  { TESTB(9, 2048, -512, -4); }
int test10b(void) { TESTB(10,  512, 2048,  0); }
int test11b(void) { TESTB(11, -512, 2048,  0); }
int test12b(void) { TESTB(12,  512,-2048,  0); }

/* values that are around min/max of the type(s) */
int test13b(void) { TESTB(13, 127, 128,  0); }
int test14b(void) { TESTB(14,-127, 128,  0); }
int test15b(void) { TESTB(15, 127,-128,  0); }
int test16b(void) { TESTB(16, 128, 127,  1); }
int test17b(void) { TESTB(17,-128, 127, -1); }
int test18b(void) { TESTB(18, 128,-127, -1); }

int test19b(void) { TESTB(19, 32767, 32768,  0); }
int test20b(void) { TESTB(20,-32767, 32768,  0); }
int test21b(void) { TESTB(21, 32767,-32768,  0); }
int test22b(void) { TESTB(22, 32768, 32767,  1); }
int test23b(void) { TESTB(23,-32768, 32767, -1); }
int test24b(void) { TESTB(24, 32768,-32767, -1); }

int test25b(void) { TESTB(25, 2147483647, 2147483648,  0); }
int test26b(void) { TESTB(26,-2147483647, 2147483648,  0); }
int test27b(void) { TESTB(27, 2147483647,-2147483648,  0); }
int test28b(void) { TESTB(28, 2147483648, 2147483647,  1); }
int test29b(void) { TESTB(29,-2147483648, 2147483647, -1); }
int test30b(void) { TESTB(30, 2147483648,-2147483647, -1); }

int main(void)
{
    res += test1a();
    res += test2a();
    res += test3a();
    res += test4a();
    res += test5a();
    res += test6a();

    res += test7a();
    res += test8a();
    res += test9a();
    res += test10a();
    res += test11a();
    res += test12a();

    res += test13a();
    res += test14a();
    res += test15a();
    res += test16a();
    res += test17a();
    res += test18a();

    res += test19a();
    res += test20a();
    res += test21a();
    res += test22a();
    res += test23a();
    res += test24a();

    res += test1b();
    res += test2b();
    res += test3b();
    res += test4b();
    res += test5b();
    res += test6b();
    
    res += test7b();
    res += test8b();
    res += test9b();
    res += test10b();
    res += test11b();
    res += test12b();

    res += test13b();
    res += test14b();
    res += test15b();
    res += test16b();
    res += test17b();
    res += test18b();

    res += test19b();
    res += test20b();
    res += test21b();
    res += test22b();
    res += test23b();
    res += test24b();
    
    return res;
}
